/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.EddystoneResolveRequest;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveStrategy;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.ResolvedId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class EddystoneCacheResolveStrategy
implements EddystoneResolveStrategy {
    private final FutureShufflesCache cache;

    EddystoneCacheResolveStrategy(FutureShufflesCache cache) {
        this.cache = cache;
    }

    @Override
    public List<EddystoneFutureUID> resolve(Map<EddystoneUid, EddystoneResolveRequest> requests) throws Exception {
        List<EddystoneUid> toResolve = this.eddystonesToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<EddystoneFutureUID> futureIds = this.resolveEddystones(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<EddystoneUid> eddystonesToResolve(Map<EddystoneUid, EddystoneResolveRequest> requests) {
        ArrayList<EddystoneUid> toResolve = new ArrayList<EddystoneUid>();
        for (Map.Entry<EddystoneUid, EddystoneResolveRequest> entry : requests.entrySet()) {
            EddystoneResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<EddystoneFutureUID> resolveEddystones(List<EddystoneUid> uids) {
        ArrayList<EddystoneFutureUID> futureIds = new ArrayList<EddystoneFutureUID>();
        for (EddystoneUid eddystoneUID : uids) {
            ResolvedId resolvedId = this.cache.get(eddystoneUID.toString());
            if (resolvedId == null || FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            EddystoneFutureUID eddystoneFutureId = new EddystoneFutureUID.Builder().futureIds(new ArrayList<EddystoneUid>()).uniqueId(resolvedId.getUniqueId()).queriedBy(eddystoneUID).resolved(resolvedId.getEddystoneUID()).build();
            futureIds.add(eddystoneFutureId);
        }
        return futureIds;
    }

    private void updateRequests(Map<EddystoneUid, EddystoneResolveRequest> requests, List<EddystoneFutureUID> futureIds) {
        for (EddystoneFutureUID id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<EddystoneUid, EddystoneResolveRequest> requests, EddystoneFutureUID id) {
        EddystoneResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.CACHE);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

