package com.kontakt.sdk.android.common.profile;

import android.os.Parcelable;

import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Model;

public interface RemoteBluetoothDevice extends Parcelable {

  double getDistance();

  long getTimestamp();

  Proximity getProximity();

  int getRssi();

  String getFirmwareVersion();

  String getName();

  String getUniqueId();

  int getBatteryPower();

  int getTxPower();

  DeviceProfile getProfile();

  boolean isShuffled();

  String getAddress();

  byte[] getPassword();

  void setPassword(byte[] password);

  Model getModel();

}
