package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.exception.IllegalOperationException;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

import static com.kontakt.sdk.android.ble.util.DeviceUtils.hasLightSensorFeature;
import static com.kontakt.sdk.android.ble.util.DeviceUtils.hasRtcFeature;

enum OperationType {

  AUTHORIZATION,
  READ_TIME,
  SYNC_TIME,
  READ_LIGHT_SENSOR,
  SECURE_CONFIG,
  SECURE_COMMAND,
  GATEWAY_READ_NETWORK_COUNT,
  GATEWAY_SELECT_NETWORK,
  GATEWAY_READ_NETWORK;

  public void validate(final RemoteBluetoothDevice device) {
    final boolean validOperation = isValidOperationForDevice(device);
    if (!validOperation) {
      final String message = "Operation not available for device model " + device.getModel() + " with firmware version " + device.getFirmwareVersion();
      throw new IllegalOperationException(message);
    }
  }

  private boolean isValidOperationForDevice(final RemoteBluetoothDevice device) {
    final Model model = (device.getModel() == null) ? Model.UNKNOWN : device.getModel();
    final String firmware = device.getFirmwareVersion();

    switch (this) {
      case READ_TIME:
      case SYNC_TIME:
        return hasRtcFeature(model, firmware);
      case READ_LIGHT_SENSOR:
        return hasLightSensorFeature(model, firmware);
      case GATEWAY_READ_NETWORK:
      case GATEWAY_READ_NETWORK_COUNT:
      case GATEWAY_SELECT_NETWORK:
        return model == Model.GATEWAY;
      default:
        return true;
    }
  }

}
