/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.os.Parcel;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecureProfileUtils {
    public static RemoteBluetoothDevice asRemoteBluetoothDevice(final ISecureProfile secureProfile) {
        return new IEddystoneDevice(){

            @Override
            public String getNamespace() {
                return secureProfile.getNamespace();
            }

            @Override
            public String getInstanceId() {
                return secureProfile.getInstanceId();
            }

            @Override
            public String getUrl() {
                return null;
            }

            @Override
            public String getEid() {
                return null;
            }

            @Override
            public Telemetry getTelemetry() {
                return null;
            }

            @Override
            public String getEncryptedTelemetry() {
                return null;
            }

            @Override
            public double getDistance() {
                return 0.0;
            }

            @Override
            public long getTimestamp() {
                return System.currentTimeMillis();
            }

            @Override
            public Proximity getProximity() {
                return Proximity.UNKNOWN;
            }

            @Override
            public int getRssi() {
                return secureProfile.getRssi();
            }

            @Override
            public String getFirmwareVersion() {
                return secureProfile.getFirmwareRevision();
            }

            @Override
            public String getName() {
                return secureProfile.getName();
            }

            @Override
            public String getUniqueId() {
                return secureProfile.getUniqueId();
            }

            @Override
            public int getBatteryPower() {
                return secureProfile.getBatteryLevel();
            }

            @Override
            public int getTxPower() {
                return secureProfile.getTxPower();
            }

            @Override
            public DeviceProfile getProfile() {
                return DeviceProfile.KONTAKT_SECURE;
            }

            @Override
            public boolean isShuffled() {
                return secureProfile.isShuffled();
            }

            @Override
            public String getAddress() {
                return secureProfile.getMacAddress();
            }

            @Override
            public byte[] getPassword() {
                return new byte[0];
            }

            @Override
            public void setPassword(byte[] password) {
            }

            @Override
            public Model getModel() {
                return secureProfile.getModel();
            }

            public int describeContents() {
                return 0;
            }

            @Override
            public int compareTo(IEddystoneDevice o) {
                return 0;
            }

            public void writeToParcel(Parcel parcel, int i) {
            }
        };
    }

    public static List<RemoteBluetoothDevice> asRemoteBluetoothDevices(List<ISecureProfile> iSecureProfiles) {
        SDKPreconditions.checkNotNull(iSecureProfiles, "List is null.");
        if (iSecureProfiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RemoteBluetoothDevice> devices = new ArrayList<RemoteBluetoothDevice>();
        for (ISecureProfile secureProfile : iSecureProfiles) {
            devices.add(SecureProfileUtils.asRemoteBluetoothDevice(secureProfile));
        }
        return devices;
    }

    public static ISecureProfile fromRemoteBluetoothDevice(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device is null.");
        return new SecureProfile.Builder(device).build();
    }

    public static List<ISecureProfile> fromRemoteBluetoothDevices(List<? extends RemoteBluetoothDevice> devices) {
        SDKPreconditions.checkNotNull(devices, "List is null.");
        if (devices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ISecureProfile> secureProfiles = new ArrayList<ISecureProfile>();
        for (RemoteBluetoothDevice remoteBluetoothDevice : devices) {
            secureProfiles.add(SecureProfileUtils.fromRemoteBluetoothDevice(remoteBluetoothDevice));
        }
        return secureProfiles;
    }
}

