/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

public enum Model {
    SMART_BEACON(1),
    SMART_BEACON_3(9),
    USB_BEACON(3),
    CARD_BEACON(4),
    GATEWAY(5),
    BEACON_PRO(6),
    PROBE(7),
    TAG_BEACON(8),
    HEAVY_DUTY_BEACON(10),
    SENSOR_BEACON(-1),
    CLOUD_BEACON(-1),
    EXTERNAL(-1),
    UNKNOWN(-1);

    private int code;

    private Model(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static Model fromString(String modelString) {
        if (modelString != null) {
            for (Model model : Model.values()) {
                if (!modelString.equalsIgnoreCase(model.name())) continue;
                return model;
            }
        }
        return SMART_BEACON;
    }

    public static Model fromCode(int code) {
        if (code <= 0) {
            return UNKNOWN;
        }
        for (Model model : Model.values()) {
            if (model.getCode() != code) continue;
            return model;
        }
        return UNKNOWN;
    }
}

