/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.managers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Manager;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CreateManagerRequestExecutor
extends RequestExecutor<Manager> {
    private final ManagersService managersService;
    private final Manager manager;

    public CreateManagerRequestExecutor(ManagersService managersService, Manager manager) {
        this.managersService = managersService;
        this.manager = manager;
    }

    @Override
    protected Call<Manager> prepareCall() {
        return this.managersService.createManager(this.params());
    }

    @Override
    public Manager execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Manager)super.execute();
    }

    @Override
    public void execute(CloudCallback<Manager> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.manager.getFirstName() != null, "cannot create manager - specify first name");
        SDKPreconditions.checkState(this.manager.getLastName() != null, "cannot create manager - specify last name");
        SDKPreconditions.checkState(this.manager.getEmail() != null, "cannot create manager - specify email");
        SDKPreconditions.checkState(this.manager.getRole() != null, "cannot create manager - specify role");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("firstName", this.manager.getFirstName());
        params.put("lastName", this.manager.getLastName());
        params.put("email", this.manager.getEmail());
        params.put("role", this.manager.getRole().name());
        return params;
    }
}

