/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.configs;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.Network;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.model.PowerSaving;
import com.kontakt.sdk.android.common.model.PowerSavingFeature;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class CreateConfigRequestExecutor
extends RequestExecutor<Config[]> {
    private final ConfigsService configsService;
    private final Config config;
    private String[] uniqueIds;
    private DeviceType type;

    public CreateConfigRequestExecutor(ConfigsService configsService, Config config) {
        this.configsService = configsService;
        this.config = config;
    }

    public CreateConfigRequestExecutor forDevices(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public CreateConfigRequestExecutor forDevices(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public CreateConfigRequestExecutor withType(DeviceType type) {
        this.type = SDKPreconditions.checkNotNull(type, "type cannot be null");
        return this;
    }

    @Override
    public Config[] execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Config[])super.execute();
    }

    @Override
    public void execute(CloudCallback<Config[]> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Config[]> prepareCall() {
        return this.configsService.createConfig(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.uniqueIds != null, "specify devices");
        SDKPreconditions.checkState(this.type != null, "specify device type");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> customConfiguration;
        List<Integer> rssi0m;
        List<Integer> rssi1m;
        List<PacketType> packets;
        List<DeviceProfile> profiles;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("deviceType", this.type.name());
        params.put("shuffled", String.valueOf(this.config.isShuffled()));
        if (this.config.getName() != null) {
            params.put("name", this.config.getName());
        }
        if (this.config.getProximity() != null) {
            params.put("proximity", this.config.getProximity().toString());
        }
        if (this.config.getMajor() != -1) {
            params.put("major", String.valueOf(this.config.getMajor()));
        }
        if (this.config.getMinor() != -1) {
            params.put("minor", String.valueOf(this.config.getMinor()));
        }
        if (this.config.getNamespace() != null) {
            params.put("namespace", this.config.getNamespace());
        }
        if (this.config.getInstanceId() != null) {
            params.put("instanceId", this.config.getInstanceId());
        }
        if (this.config.getUrl() != null) {
            params.put("url", this.config.getHexUrl());
        }
        if (this.config.getTxPower() != -1) {
            params.put("txPower", String.valueOf(this.config.getTxPower()));
        }
        if (this.config.getInterval() != -1) {
            params.put("interval", String.valueOf(this.config.getInterval()));
        }
        if (this.config.getPassword() != null) {
            params.put("password", this.config.getPassword());
        }
        if (this.config.getPowerSaving() != null) {
            this.addPowerSavingParams(params, this.config.getPowerSaving());
        }
        if (this.config.getGatewayNetwork() != null) {
            this.addGatewayNetworkParams(params, this.config.getGatewayNetwork());
        }
        if ((profiles = this.config.getProfiles()) != null && !profiles.isEmpty()) {
            params.put("profiles", StringUtils.join(profiles, ","));
        }
        if ((packets = this.config.getPackets()) != null && !packets.isEmpty()) {
            params.put("packets", StringUtils.join(packets, ","));
        }
        if ((rssi1m = this.config.getRssi1m()) != null && !rssi1m.isEmpty()) {
            params.put("rssi1m", StringUtils.join(rssi1m, ","));
        }
        if ((rssi0m = this.config.getRssi0m()) != null && !rssi0m.isEmpty()) {
            params.put("rssi0m", StringUtils.join(rssi0m, ","));
        }
        if (this.config.getTemperatureOffset() != 127) {
            params.put("temperatureOffset", String.valueOf(this.config.getTemperatureOffset()));
        }
        if ((customConfiguration = this.config.getCustomConfiguration()) != null) {
            for (String key : customConfiguration.keySet()) {
                String keyParam = "customConfiguration." + key;
                String value = customConfiguration.get(key);
                params.put(keyParam, value);
            }
        }
        return params;
    }

    private void addGatewayNetworkParams(Map<String, String> params, Network network) {
        if (network.getName() != null) {
            params.put("applications.system.wifiSsid", network.getName());
        }
        if (network.getLogin() != null) {
            params.put("applications.system.wifiUserName", network.getLogin());
        }
        if (network.getPassword() != null) {
            params.put("applications.system.passwordWifi", network.getPassword());
        }
        if (network.getApiKey() != null) {
            params.put("applications.system.apiKey", network.getApiKey());
        }
        if (network.getType() != null && !network.getType().contains((Object)Network.Type.NONE)) {
            if (network.isEnterprise()) {
                params.put("applications.system.wifiProtocol", "WPA_EAP");
            } else if (network.isPersonal()) {
                params.put("applications.system.wifiProtocol", "WPA_PSK");
            }
        }
    }

    private void addPowerSavingParams(Map<String, String> params, PowerSaving powerSaving) {
        List<PowerSavingFeature> features;
        long moveSuspendTimeout;
        int lightSensorThreshold;
        long lightSensorSamplingInterval;
        int lightSensorHysteresis = powerSaving.getLightSensorHysteresis();
        if (lightSensorHysteresis != -1) {
            params.put(this.asPowerSavingParam("lightSensorHysteresis"), String.valueOf(lightSensorHysteresis));
        }
        if ((lightSensorSamplingInterval = powerSaving.getLightSensorSamplingInterval()) != -1L) {
            params.put(this.asPowerSavingParam("lightSensorSamplingInterval"), String.valueOf(lightSensorSamplingInterval));
        }
        if ((lightSensorThreshold = powerSaving.getLightSensorThreshold()) != -1) {
            params.put(this.asPowerSavingParam("lightSensorThreshold"), String.valueOf(lightSensorThreshold));
        }
        if ((moveSuspendTimeout = powerSaving.getMoveSuspendTimeout()) > 0L) {
            params.put(this.asPowerSavingParam("moveSuspendTimeout"), String.valueOf(moveSuspendTimeout));
        }
        if ((features = powerSaving.getFeatures()) != null) {
            params.put(this.asPowerSavingParam("features"), StringUtils.join(features, ","));
        }
    }

    private String asPowerSavingParam(String param) {
        return StringUtils.join(Arrays.asList("powerSaving", param), ".");
    }
}

