/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import com.kontakt.sdk.android.common.FileData;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class FileDataCallbackWrapper
implements Callback<ResponseBody> {
    private final CloudCallback<FileData> callback;

    public FileDataCallbackWrapper(CloudCallback<FileData> callback) {
        this.callback = callback;
    }

    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : response.headers().names()) {
            headers.put(key, response.headers().get(key));
        }
        if (response.isSuccessful()) {
            FileData fileData;
            ResponseBody body = (ResponseBody)response.body();
            if (body == null) {
                fileData = FileData.empty();
            } else {
                try {
                    fileData = FileData.of(body.bytes());
                }
                catch (IOException e) {
                    fileData = FileData.empty();
                }
            }
            this.callback.onSuccess(fileData, CloudHeaders.of(headers));
        } else {
            CloudError cloudError = ErrorUtils.parseError(response);
            this.callback.onError(cloudError);
        }
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        CloudError error = new CloudError(null, -1, t.getLocalizedMessage());
        this.callback.onError(error);
    }
}

