/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.concurrent.TimeUnit;

final class Runners {
    private Runners() {
    }

    static Runnable newRunner(RunnerType runnerType, ScanConfiguration configuration) {
        SDKPreconditions.checkNotNull(runnerType, "Runner type cannot be null");
        SDKPreconditions.checkNotNull(configuration, "Configuration cannot be null");
        switch (runnerType) {
            case MONITOR_ACTIVE_RUNNER: {
                return Runners.newMonitorActiveRunner(configuration);
            }
            case MONITOR_PASSIVE_RUNNER: {
                return Runners.newMonitorPassiveRunner(configuration);
            }
            case FORCE_SCAN_RUNNER: {
                return Runners.newForceScanRunner(configuration);
            }
        }
        throw new RuntimeException();
    }

    private static Runnable newForceScanRunner(ScanConfiguration configuration) {
        final MonitorCallback monitorCallback = (MonitorCallback)configuration.getScanCallback();
        ForceScanConfiguration forceScanConfiguration = configuration.getScanContext().getForceScanConfiguration();
        final long forceScanActivePeriod = forceScanConfiguration.getForceScanActivePeriod();
        final long forceScanPassivePeriod = forceScanConfiguration.getForceScanPassivePeriod();
        return new Runnable(){

            @Override
            @TargetApi(value=18)
            public void run() {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                try {
                    if (bluetoothAdapter == null) {
                        Runners.onBluetoothAdapterNotInitialized(monitorCallback);
                        return;
                    }
                    while (!Thread.currentThread().isInterrupted()) {
                        Logger.d("Stopping Scan (force)");
                        bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during passive period: %s", String.valueOf(forceScanPassivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanPassivePeriod);
                        Logger.d("Starting scan (force)");
                        bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during active period: %s", String.valueOf(forceScanActivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanActivePeriod);
                    }
                    bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                    Logger.d("Force scan finished");
                }
                catch (InterruptedException e) {
                    bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                    Logger.d("Force scan interrupted");
                }
            }
        };
    }

    private static Runnable newMonitorPassiveRunner(ScanConfiguration configuration) {
        final MonitorCallback monitorCallback = (MonitorCallback)configuration.getScanCallback();
        return new Runnable(){

            @Override
            @TargetApi(value=18)
            public void run() {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (bluetoothAdapter == null) {
                    Runners.onBluetoothAdapterNotInitialized(monitorCallback);
                    return;
                }
                bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                monitorCallback.onMonitorCycleStop();
            }
        };
    }

    private static Runnable newMonitorActiveRunner(ScanConfiguration serviceConfiguration) {
        final MonitorCallback monitorCallback = (MonitorCallback)serviceConfiguration.getScanCallback();
        return new Runnable(){

            @Override
            @TargetApi(value=18)
            public void run() {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (bluetoothAdapter == null) {
                    Runners.onBluetoothAdapterNotInitialized(monitorCallback);
                    return;
                }
                bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)monitorCallback);
                monitorCallback.onMonitorCycleStart();
            }
        };
    }

    private static void onBluetoothAdapterNotInitialized(MonitorCallback monitorCallback) {
        String message = "Unexpected error occurred - BluetoothAdapter is null.";
        Logger.e("Unexpected error occurred - BluetoothAdapter is null.");
        monitorCallback.onScanError(new ScanError("Unexpected error occurred - BluetoothAdapter is null."));
    }

    static enum RunnerType {
        MONITOR_ACTIVE_RUNNER,
        MONITOR_PASSIVE_RUNNER,
        FORCE_SCAN_RUNNER;

    }
}

