/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PayloadResolver;
import com.kontakt.sdk.android.common.model.Model;
import java.util.Arrays;
import java.util.Locale;

public class PlainDevicePayloadResolver
extends PayloadResolver {
    private static final byte PAYLOAD_IDENTIFIER = 2;

    public PlainDevicePayloadResolver() {
        super((byte)2);
    }

    @Override
    public void resolve(FramePayload payload) {
        if (payload == null) {
            return;
        }
        String macAddress = payload.getAddress();
        String name = this.getName(payload);
        byte[] serviceData = this.getServiceData(payload);
        Model model = Model.fromCode(serviceData[3]);
        String firmware = this.parseFirmwareVersion(serviceData);
        byte batteryLevel = serviceData[6];
        byte txPower = serviceData[7];
        String uniqueId = this.parseUniqueId(serviceData);
        SecureProfile secureProfile = new SecureProfile.Builder().macAddress(macAddress).name(name).model(model).firmwareRevision(firmware).batteryLevel(batteryLevel).txPower(txPower).uniqueId(uniqueId).shuffled(false).build();
        this.onPayloadResolved(secureProfile);
    }

    private String parseFirmwareVersion(byte[] serviceData) {
        byte firmwareVersionMajor = serviceData[4];
        byte firmwareVersionMinor = serviceData[5];
        if (firmwareVersionMajor < 0 || firmwareVersionMinor < 0) {
            return "";
        }
        return String.format(Locale.getDefault(), "%d.%d", (int)firmwareVersionMajor, (int)firmwareVersionMinor);
    }

    private String parseUniqueId(byte[] serviceData) {
        return new String(Arrays.copyOfRange(serviceData, 8, serviceData.length));
    }
}

