/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

public final class InstanceIdResolver
implements PropertyResolver<String> {
    public static final int DEFAULT_INSTANCE_ID_START_INDEX = 14;
    public static final int SECURE_PROFILE_INSTANCE_ID_START_INDEX = 18;
    private static final int INSTANCE_ID_LENGTH = 6;
    private static final int MASK = 255;
    private static final String FORMAT = "%02x";
    private final StringBuilder stringBuilder = new StringBuilder();
    private final int instanceIdStartIndex;

    public InstanceIdResolver(int instanceIdStartIndex) {
        this.instanceIdStartIndex = instanceIdStartIndex;
    }

    @Override
    public String parse(byte[] packet) {
        if (packet == null) {
            return null;
        }
        byte[] bytes = ConversionUtils.extractSubdata(packet, this.instanceIdStartIndex, 6);
        if (bytes == null) {
            return null;
        }
        this.stringBuilder.setLength(0);
        for (byte byteValue : bytes) {
            this.stringBuilder.append(String.format(FORMAT, byteValue & 0xFF));
        }
        return this.stringBuilder.toString();
    }
}

