/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.content.Context;
import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.InternalSecureBeaconWriteListener;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.SyncableKontaktDeviceConnection;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.KontaktCloudFactory;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

class SyncableKontaktDeviceConnectionImpl
implements SyncableKontaktDeviceConnection {
    private KontaktDeviceConnectionImpl kontaktDeviceConnection;
    private KontaktCloud kontaktCloud;

    SyncableKontaktDeviceConnectionImpl(Context context, RemoteBluetoothDevice remoteBluetoothDevice, KontaktDeviceConnection.ConnectionListener connectionListener) {
        this.kontaktDeviceConnection = new KontaktDeviceConnectionImpl(context, remoteBluetoothDevice, connectionListener);
        this.kontaktCloud = KontaktCloudFactory.create();
    }

    @Override
    public synchronized boolean connectToDevice() {
        return this.kontaktDeviceConnection.connect();
    }

    @Override
    public synchronized boolean isConnectedToDevice() {
        return this.kontaktDeviceConnection.isConnected();
    }

    @Override
    public synchronized void close() {
        this.kontaktDeviceConnection.close();
    }

    @Override
    public synchronized RemoteBluetoothDevice getDevice() {
        return this.kontaktDeviceConnection.getDevice();
    }

    @Override
    public synchronized boolean isDeviceAuthenticated() {
        return this.kontaktDeviceConnection.isAuthenticated();
    }

    @Override
    public void applySecureConfig(Config secureConfig, SyncWriteListener syncWriteListener) {
        this.kontaktDeviceConnection.applySecureConfig(secureConfig.getSecureRequest(), new InternalSecureBeaconWriteListener(syncWriteListener, this.kontaktCloud, this.getDeviceUniqueId()));
    }

    private String getDeviceUniqueId() {
        return this.getDevice().getUniqueId();
    }

    public static abstract class SyncWriteListener {
        public static final int SYNC_NOT_IMPLEMENTED_YET = -1;

        @Deprecated
        public void onWriteFailed() {
        }

        public void onWriteFailed(ErrorCause cause) {
        }

        public void onSyncFailed(KontaktCloudException e) {
        }

        public void onSyncFailed(CloudError e) {
        }

        public void onSyncFailed(KontaktCloudException e, String response) {
        }

        public void onSyncFailed(CloudError e, Config secureResponse) {
        }

        public void onSuccess() {
        }
    }
}

