package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of device model.
 */
public enum Model {

  /**
   * Smart Beacon device model.
   */
  SMART_BEACON(1),

  /**
   * Smart Beacon 3 device model.
   */
  SMART_BEACON_3(9),

  /**
   * USB Beacon device model.
   */
  USB_BEACON(3),

  /**
   * Card Beacon device model.
   */
  CARD_BEACON(4),

  /**
   * Gateway device model.
   */
  GATEWAY(5),

  /**
   * Beacon PRO device model.
   */
  BEACON_PRO(6),

  /**
   * PROBE device model.
   */
  PROBE(7),

  /**
   * Tag Beacon device model.
   */
  TAG_BEACON(8),

  /**
   * Heavy Duty Beacon device model.
   */
  HEAVY_DUTY_BEACON(10),

  /**
   * Sensor Beacon device model.
   */
  SENSOR_BEACON(-1),

  /**
   * Cloud Beacon device model.
   */
  CLOUD_BEACON(-1),

  /**
   * External device model.
   */
  EXTERNAL(-1),

  UNKNOWN(-1);

  private int code;

  Model(int code) {
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  public static Model fromString(String modelString) {
    if (modelString != null) {
      for (Model model : Model.values()) {
        if (modelString.equalsIgnoreCase(model.name())) {
          return model;
        }
      }
    }
    return SMART_BEACON;
  }

  public static Model fromCode(int code) {
    if (code <= 0) {
      return UNKNOWN;
    }
    for (Model model : Model.values()) {
      if (model.getCode() == code) {
        return model;
      }
    }
    return UNKNOWN;
  }
}
