package com.kontakt.sdk.android.cloud.response.paginated;

import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Place;
import java.util.List;

/**
 * Places API response representation composed of place list and search meta data.
 */
public class Places extends PaginatedResponse<List<Place>> {

  @SerializedName("places") protected List<Place> places;

  /**
   * Returns the place list.
   *
   * @return the place list.
   */
  @Override
  public List<Place> getContent() {
    return places;
  }

}
