package com.kontakt.sdk.android.ble.spec;

public enum TelemetryError {

  INTERNAL_ERROR(1),
  NO_INTERNET(1 << 1);

  private final int value;

  TelemetryError(int value) {
    this.value = value;
  }

  public int value() {
    return value;
  }

  public static TelemetryError fromValue(final int value) {
    for (final TelemetryError error : values()) {
      if (error.value == value) return error;
    }
    return null;
  }
}
