package com.kontakt.sdk.android.ble.dfu.firmwares;

import com.kontakt.sdk.android.common.model.Firmware;

/**
 * This class is responsible for fetching and caching firmwares files.
 */
public interface IFirmwareFilesManager {

  /**
   * Fetches or retrieves from cache given firmware file
   * @param firmware Valid {@link Firmware} instance
   */
  void getFirmwareFile(Firmware firmware, FirmwareFileCallback callback);

  /**
   * Closes manager and releases resources.
   */
  void close();

}
