package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.common.model.Network;

public interface KontaktGatewayConnection extends KontaktDeviceConnection {

  /**
   * Read will initialize networks array. This array will be sorted by RSSI (highest on index 0).
   * It is guaranteed that networks array won't change between reads.
   */
  void readNetworksCount(ReadListener<Integer> listener);

  /**
   * Points an index of a network that details should be retrieved.
   *
   * @param index index of a network.
   * @param listener write listener.
   */
  void selectNetworkToRead(int index, WriteListener listener);

  /**
   * Reads details of a network previously pointed by {@link KontaktGatewayConnection#selectNetworkToRead(int, WriteListener)} method.
   *
   * @param listener read listener.
   */
  void readSelectedNetwork(ReadListener<Network> listener);
}
