package com.kontakt.sdk.android.ble.connection;

/**
 * {@link KontaktDeviceConnection} possible errors.
 */
public class DeviceConnectionError {

  /**
   * Error code informing that Beacon services discovery has failed.
   */
  public static final int ERROR_SERVICES_DISCOVERY = 1;

  /**
   * Failure code informing that BLE device was not recognised as kontakt.io
   * Beacon.
   */
  public static final int FAILURE_UNKNOWN_BEACON = 2;

  static final int GATT_ERROR_BEGIN = 1000;

  /**
   * Metohd for checking is error code indicating GATT error
   *
   * @param errorCode received from {@link KontaktDeviceConnection.ConnectionListener#onErrorOccured(int)}
   * @return true if errorCode is gatt error
   */
  public static boolean isGattError(int errorCode) {
    return errorCode > GATT_ERROR_BEGIN;
  }

  /**
   * Method for getting gatt error status code from received errorCode
   * <br><br> throws {@link IllegalAccessException} if errorCode is not gatt error code
   *
   * @param errorCode error code
   * @return Gatt status code, e.g 133
   */
  public static int getGattError(int errorCode) {
    if (!isGattError(errorCode)) {
      throw new IllegalArgumentException("Error code is not gatt error");
    }
    return errorCode - GATT_ERROR_BEGIN;
  }

  static int toGattError(int errorCode) {
    return errorCode + GATT_ERROR_BEGIN;
  }

}
