/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.IFutureId;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

public class SecureProfileFutureUID
implements IFutureId<SecureProfileUid> {
    public static final Parcelable.Creator<SecureProfileFutureUID> CREATOR = new Parcelable.Creator<SecureProfileFutureUID>(){

        public SecureProfileFutureUID createFromParcel(Parcel source) {
            return new SecureProfileFutureUID(source);
        }

        public SecureProfileFutureUID[] newArray(int size) {
            return new SecureProfileFutureUID[size];
        }
    };
    private String uniqueId;
    private SecureProfileUid queriedBy;
    private SecureProfileUid resolved;
    private List<SecureProfileUid> futureIds;

    public static Builder builder() {
        return new Builder();
    }

    SecureProfileFutureUID(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.queriedBy = builder.queriedBy;
        this.resolved = builder.resolved;
        this.futureIds = builder.futureIds;
    }

    protected SecureProfileFutureUID(Parcel in) {
        this.uniqueId = in.readString();
        this.queriedBy = (SecureProfileUid)in.readParcelable(SecureProfileUid.class.getClassLoader());
        this.resolved = (SecureProfileUid)in.readParcelable(SecureProfileUid.class.getClassLoader());
        this.futureIds = in.createTypedArrayList(SecureProfileUid.CREATOR);
    }

    @Override
    public SecureProfileUid getQueriedBy() {
        return this.queriedBy;
    }

    @Override
    public SecureProfileUid getResolved() {
        return this.resolved;
    }

    @Override
    public List<SecureProfileUid> getFutureIds() {
        return this.futureIds;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SecureProfileFutureUID)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        SecureProfileFutureUID other = (SecureProfileFutureUID)o;
        return SDKEqualsBuilder.start().equals(this.resolved, other.resolved).equals(this.queriedBy, other.queriedBy).equals(this.futureIds, other.futureIds).equals(this.uniqueId, other.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.resolved).append(this.queriedBy).append(this.futureIds).append(this.uniqueId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeParcelable((Parcelable)this.queriedBy, flags);
        dest.writeParcelable((Parcelable)this.resolved, flags);
        dest.writeTypedList(this.futureIds);
    }

    public static class Builder {
        String uniqueId;
        SecureProfileUid queriedBy;
        SecureProfileUid resolved;
        List<SecureProfileUid> futureIds = new ArrayList<SecureProfileUid>();

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder queriedBy(SecureProfileUid queriedBy) {
            this.queriedBy = queriedBy;
            return this;
        }

        public Builder resolved(SecureProfileUid resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder futureIds(List<SecureProfileUid> futureIds) {
            SDKPreconditions.checkNotNull(futureIds, "future IDs cannot be null");
            this.futureIds.clear();
            this.futureIds.addAll(futureIds);
            return this;
        }

        public SecureProfileFutureUID build() {
            return new SecureProfileFutureUID(this);
        }
    }
}

