/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.response.paginated.Venues;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.model.VenueType;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class VenuesRequestExecutor
extends PaginatedRequestExecutor<Venues> {
    private final VenuesService venuesService;
    private UUID[] managerIds;
    private VenueType type;

    public VenuesRequestExecutor(VenuesService venuesService) {
        this.venuesService = venuesService;
    }

    public VenuesRequestExecutor managerIds(UUID ... managerIds) {
        this.managerIds = SDKPreconditions.checkNotNull(managerIds, "managerIds cannot be null");
        return this;
    }

    public VenuesRequestExecutor managerIds(List<UUID> managerIds) {
        SDKPreconditions.checkNotNull(managerIds, "managerIds cannot be null");
        int size = managerIds.size();
        this.managerIds = managerIds.toArray(new UUID[size]);
        return this;
    }

    public VenuesRequestExecutor type(VenueType type) {
        this.type = SDKPreconditions.checkNotNull(type, "type cannot be null");
        return this;
    }

    @Override
    public VenuesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public VenuesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public VenuesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public VenuesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public VenuesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Venues> prepareCall() {
        Call<Venues> call = this.eTag != null ? this.venuesService.getVenues(this.params(), this.eTag) : this.venuesService.getVenues(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.managerIds != null) {
            params.put("managerId", StringUtils.join(this.managerIds, ","));
        }
        if (this.type != null) {
            params.put("venueType", this.type.name());
        }
        return params;
    }
}

