/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.managers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.common.model.Manager;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdateManagerRequestExecutor
extends RequestExecutor<String> {
    private final ManagersService managersService;
    private final UUID managerId;
    private Manager manager;

    public UpdateManagerRequestExecutor(ManagersService managersService, UUID managerId) {
        this.managersService = managersService;
        this.managerId = managerId;
    }

    public UpdateManagerRequestExecutor with(Manager manager) {
        SDKPreconditions.checkNotNull(manager, "manager cannot be null");
        this.manager = manager;
        return this;
    }

    @Override
    protected Call<String> prepareCall() {
        return this.managersService.updateManager(this.params());
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("managerId", this.managerId.toString());
        if (this.manager.getFirstName() != null) {
            params.put("firstName", this.manager.getFirstName());
        }
        if (this.manager.getLastName() != null) {
            params.put("lastName", this.manager.getLastName());
        }
        if (this.manager.getEmail() != null) {
            params.put("email", this.manager.getEmail());
        }
        if (this.manager.getRole() != null) {
            params.put("role", this.manager.getRole().name());
        }
        return params;
    }
}

