/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.model.PowerSaving;
import com.kontakt.sdk.android.common.model.PowerSavingFeature;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ConfigTypeAdapter
extends BaseTypeAdapter<Config> {
    private final Gson gson = new Gson();

    public void write(JsonWriter out, Config config) throws IOException {
        this.writeUUID(out, "proximity", config.getProximity());
        this.writeInteger(out, "major", config.getMajor());
        this.writeInteger(out, "minor", config.getMinor());
        this.writeInteger(out, "txPower", config.getTxPower());
        this.writeInteger(out, "interval", config.getInterval());
        this.writeString(out, "namespace", config.getNamespace());
        this.writeString(out, "instanceId", config.getInstanceId());
        String url = config.getUrl();
        if (url != null) {
            String encodedUrl = EddystoneUtils.toHexString(EddystoneUtils.serializeUrl(url));
            this.writeString(out, "url", encodedUrl);
        }
        this.writeProfiles(out, config.getProfiles());
        this.writePackets(out, config.getPackets());
        this.writeBoolean(out, "shuffled", config.isShuffled());
        this.writeString(out, "name", config.getName());
        this.writeString(out, "password", config.getPassword());
        this.writeRssiCalibration(out, config.getRssi1m(), "rssi1m");
        this.writeRssiCalibration(out, config.getRssi0m(), "rssi0m");
        this.writeString(out, "config", config.getSecureRequest());
        this.writeString(out, "response", config.getSecureResponse());
        this.writeLong(out, "updated", config.getSecureResponseTime());
        this.writePowerSaving(out, config);
        this.writeInteger(out, "temperatureOffset", config.getTemperatureOffset());
        this.writeCustomConfiguration(out, config.getCustomConfiguration());
    }

    public Config read(JsonReader in) throws IOException {
        Config.Builder configBuilder = new Config.Builder();
        in.beginObject();
        block46: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "uniqueId": {
                    String uniqueId = in.nextString();
                    configBuilder.uniqueId(uniqueId);
                    continue block46;
                }
                case "proximity": {
                    UUID proximity = UUID.fromString(in.nextString());
                    configBuilder.proximity(proximity);
                    continue block46;
                }
                case "major": {
                    int major = in.nextInt();
                    configBuilder.major(major);
                    continue block46;
                }
                case "minor": {
                    int minor = in.nextInt();
                    configBuilder.minor(minor);
                    continue block46;
                }
                case "txPower": {
                    int txPower = in.nextInt();
                    configBuilder.txPower(txPower);
                    continue block46;
                }
                case "interval": {
                    int interval = in.nextInt();
                    configBuilder.interval(interval);
                    continue block46;
                }
                case "namespace": {
                    String namespace = in.nextString();
                    configBuilder.namespace(namespace);
                    continue block46;
                }
                case "url": {
                    String url = in.nextString();
                    configBuilder.url(url);
                    continue block46;
                }
                case "instanceId": {
                    String instanceId = in.nextString();
                    configBuilder.instanceId(instanceId);
                    continue block46;
                }
                case "profiles": {
                    List<DeviceProfile> profiles = this.readProfiles(in);
                    configBuilder.profiles(profiles);
                    continue block46;
                }
                case "packets": {
                    List<PacketType> packets = this.readPackets(in);
                    configBuilder.packets(packets);
                    continue block46;
                }
                case "shuffled": {
                    boolean shuffled = in.nextBoolean();
                    configBuilder.shuffled(shuffled);
                    continue block46;
                }
                case "name": {
                    String name = in.nextString();
                    configBuilder.name(name);
                    continue block46;
                }
                case "password": {
                    String password = in.nextString();
                    configBuilder.password(password);
                    continue block46;
                }
                case "rssi1m": {
                    configBuilder.rssi1m(this.readRssiCalibration(in));
                    continue block46;
                }
                case "rssi0m": {
                    configBuilder.rssi0m(this.readRssiCalibration(in));
                    continue block46;
                }
                case "config": {
                    String secureRequest = in.nextString();
                    configBuilder.secureRequest(secureRequest);
                    continue block46;
                }
                case "powerSaving": {
                    PowerSaving powerSaving = this.readPowerSaving(in);
                    configBuilder.powerSaving(powerSaving);
                    continue block46;
                }
                case "temperatureOffset": {
                    int temperatureOffset = in.nextInt();
                    configBuilder.temperatureOffset(temperatureOffset);
                    continue block46;
                }
                case "customConfiguration": {
                    try {
                        Map<String, String> customConfiguration = this.readCustomConfiguration(in);
                        configBuilder.customConfiguration(customConfiguration);
                    }
                    catch (Exception e) {
                        in.skipValue();
                    }
                    continue block46;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return configBuilder.build();
    }

    private void writePowerSaving(JsonWriter out, Config config) throws IOException {
        PowerSaving powerSaving = config.getPowerSaving();
        if (powerSaving == null) {
            return;
        }
        out.name("powerSaving");
        out.beginObject();
        this.writeLong(out, "moveSuspendTimeout", powerSaving.getMoveSuspendTimeout());
        this.writeInteger(out, "lightSensorHysteresis", powerSaving.getLightSensorHysteresis());
        this.writeInteger(out, "lightSensorThreshold", powerSaving.getLightSensorThreshold());
        this.writeLong(out, "lightSensorSamplingInterval", powerSaving.getLightSensorSamplingInterval());
        this.writeFeatures(out, powerSaving.getFeatures());
        out.endObject();
    }

    private void writeProfiles(JsonWriter out, List<DeviceProfile> profiles) throws IOException {
        out.name("profiles");
        if (profiles == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (DeviceProfile profile : profiles) {
            out.value(profile.name());
        }
        out.endArray();
    }

    private void writePackets(JsonWriter out, List<PacketType> packets) throws IOException {
        out.name("packets");
        if (packets == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (PacketType packet : packets) {
            out.value(packet.name());
        }
        out.endArray();
    }

    private void writeFeatures(JsonWriter out, List<PowerSavingFeature> features) throws IOException {
        out.name("features");
        if (features == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (PowerSavingFeature feature : features) {
            out.value(feature.toString());
        }
        out.endArray();
    }

    private void writeRssiCalibration(JsonWriter out, List<Integer> rssi, String cloudParam) throws IOException {
        out.name(cloudParam);
        if (rssi == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (Integer i : rssi) {
            out.value((Number)i);
        }
        out.endArray();
    }

    private void writeCustomConfiguration(JsonWriter out, Map<String, String> customConfiguration) throws IOException {
        out.name("customConfiguration");
        if (customConfiguration == null) {
            out.nullValue();
            return;
        }
        out.value(this.gson.toJson(customConfiguration));
    }

    PowerSaving readPowerSaving(JsonReader in) throws IOException {
        PowerSaving.Builder powerSavingBuilder = new PowerSaving.Builder();
        in.beginObject();
        block14: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "moveSuspendTimeout": {
                    powerSavingBuilder.moveSuspendTimeout(in.nextLong());
                    continue block14;
                }
                case "lightSensorHysteresis": {
                    powerSavingBuilder.lightSensorHysteresis(in.nextInt());
                    continue block14;
                }
                case "lightSensorSamplingInterval": {
                    powerSavingBuilder.lightSensorSamplingInterval(in.nextInt());
                    continue block14;
                }
                case "lightSensorThreshold": {
                    powerSavingBuilder.lightSensorThreshold(in.nextInt());
                    continue block14;
                }
                case "features": {
                    powerSavingBuilder.features(this.readFeatures(in));
                    continue block14;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return powerSavingBuilder.build();
    }

    List<DeviceProfile> readProfiles(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<DeviceProfile> profiles = new ArrayList<DeviceProfile>();
        while (in.hasNext()) {
            profiles.add(DeviceProfile.valueOf(in.nextString()));
        }
        in.endArray();
        return profiles;
    }

    List<PacketType> readPackets(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<PacketType> packets = new ArrayList<PacketType>();
        while (in.hasNext()) {
            packets.add(PacketType.valueOf(in.nextString()));
        }
        in.endArray();
        return packets;
    }

    List<PowerSavingFeature> readFeatures(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<PowerSavingFeature> features = new ArrayList<PowerSavingFeature>();
        while (in.hasNext()) {
            PowerSavingFeature f = PowerSavingFeature.fromString(in.nextString());
            if (f == null) continue;
            features.add(f);
        }
        in.endArray();
        return features;
    }

    List<Integer> readRssiCalibration(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<Integer> rssi = new ArrayList<Integer>();
        while (in.hasNext()) {
            rssi.add(in.nextInt());
        }
        in.endArray();
        return rssi;
    }

    Map<String, String> readCustomConfiguration(JsonReader in) throws IOException {
        in.beginObject();
        HashMap<String, String> customConfiguration = new HashMap<String, String>();
        while (in.hasNext()) {
            customConfiguration.put(in.nextName(), in.nextString());
        }
        in.endObject();
        return customConfiguration;
    }
}

