/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.bluetooth.BluetoothDevice;
import android.util.SparseArray;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.secure_profile.ParseListener;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PayloadResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PlainDevicePayloadResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.ResolveListener;
import com.kontakt.sdk.android.ble.discovery.secure_profile.ShuffledDevicePayloadResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.TelemetryPayloadResolver;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class SecureProfileParser
extends Parser<SecureProfile> {
    private static final byte[] KONTAKT_SECURE_PROFILE_PREFIX = new byte[]{22, 106, -2};
    private static final int MIN_SECURE_PROFILE_LENGTH = 14;
    private final SparseArray<PayloadResolver> resolvers = new SparseArray();
    private final Map<String, Integer> rssiCache = new HashMap<String, Integer>();
    private ParseListener parseListener;
    final PayloadResolver plainDevicePayloadResolver;
    final ShuffledDevicePayloadResolver shuffledDevicePayloadResolver;
    final PayloadResolver telemetryPayloadResolver;
    private final ResolveListener resolveListener = new ResolveListener(){

        @Override
        public void onResolved(SecureProfile profile) {
            String macAddress = profile.getMacAddress();
            int hashCode = SecureProfileParser.this.hashCodeBuilder.append(macAddress).build();
            SecureProfile cachedProfile = (SecureProfile)SecureProfileParser.this.devicesCache.get(hashCode);
            if (cachedProfile != null) {
                profile = cachedProfile.updateWith(profile);
            } else {
                SecureProfileParser.this.devicesCache.put(hashCode, profile);
            }
            int rssi = (Integer)SecureProfileParser.this.rssiCache.get(macAddress);
            profile.setRssi(rssi);
            SecureProfileParser.this.parseListener.onParsed(profile);
        }
    };

    SecureProfileParser(ScanContext scanContext, FutureShufflesCache shufflesCache) {
        super(scanContext);
        this.plainDevicePayloadResolver = new PlainDevicePayloadResolver();
        this.shuffledDevicePayloadResolver = new ShuffledDevicePayloadResolver(shufflesCache);
        this.telemetryPayloadResolver = new TelemetryPayloadResolver();
        this.addResolver(this.plainDevicePayloadResolver);
        this.addResolver(this.shuffledDevicePayloadResolver);
        this.addResolver(this.telemetryPayloadResolver);
        List<PayloadResolver> customPayloadResolvers = scanContext.getCustomSecureProfilePayloadResolvers();
        for (PayloadResolver payloadResolver : customPayloadResolvers) {
            this.addResolver(payloadResolver);
        }
    }

    void addListener(ParseListener parseListener) {
        this.parseListener = parseListener;
    }

    public void addResolver(PayloadResolver resolver) {
        if (resolver != null) {
            resolver.attachListener(this.resolveListener);
            this.resolvers.put((int)resolver.payloadId, (Object)resolver);
        }
    }

    boolean isValidSecureProfileFrame(byte[] scanRecord) {
        return ConversionUtils.doesArrayContainSubset(scanRecord, KONTAKT_SECURE_PROFILE_PREFIX, 4) && scanRecord.length > 14;
    }

    void parseSecureProfile(BluetoothDevice device, int rssi, byte[] scanRecord) {
        HashMap<FrameDataType, byte[]> frameData = new HashMap<FrameDataType, byte[]>();
        this.extractFrameData(scanRecord, frameData);
        byte[] serviceData = (byte[])frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        byte payloadId = serviceData[2];
        PayloadResolver resolver = (PayloadResolver)this.resolvers.get((int)payloadId);
        if (resolver != null) {
            String address = device.getAddress();
            this.updateRssi(address, rssi);
            FramePayload payload = new FramePayload(address, frameData);
            resolver.resolve(payload);
        }
    }

    private void updateRssi(String macAddress, int rssi) {
        int calculatedRssi = this.rssiCalculator.calculateRssi(macAddress.hashCode(), rssi);
        this.rssiCache.put(macAddress, calculatedRssi);
    }

    void handleLostEvent(ISecureProfile profile) {
        this.shuffledDevicePayloadResolver.handleLostEvent(profile);
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
        }
        this.shuffledDevicePayloadResolver.disableShuffleResolver();
    }
}

