/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.SparseLongArray;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.secure_profile.ParseListener;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileParser;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=18)
public class SecureProfileDiscoverer
implements BluetoothDeviceDiscoverer,
ParseListener {
    private final Map<String, ISecureProfile> cache;
    private final SecureProfileParser parser;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final SparseLongArray secureProfileTimestampArray;
    private final DiscoveryContract discoveryContract;
    private final long deviceUpdateIntervalCallback;
    private long lastUpdateCallbackMillis;

    public SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, FutureShufflesCache shufflesCache) {
        this.deviceUpdateIntervalCallback = scanContext.getDeviceUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.secureProfileTimestampArray = new SafeSparseLongArray();
        this.discoveryContract = discoveryContract;
        this.cache = new ConcurrentHashMap<String, ISecureProfile>();
        this.parser = new SecureProfileParser(scanContext, shufflesCache);
        this.parser.addListener(this);
    }

    SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, SparseLongArray secureProfileTimestampArray, Map<String, ISecureProfile> cache, FutureShufflesCache shufflesCache) {
        this.discoveryContract = discoveryContract;
        this.deviceUpdateIntervalCallback = scanContext.getDeviceUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.secureProfileTimestampArray = secureProfileTimestampArray;
        this.cache = cache;
        this.parser = new SecureProfileParser(scanContext, shufflesCache);
        this.parser.addListener(this);
    }

    @Override
    public void performDiscovery(BluetoothDevice device, int rssi, byte[] scanResult) {
        if (!this.parser.isValidSecureProfileFrame(scanResult)) {
            return;
        }
        this.parser.parseSecureProfile(device, rssi, scanResult);
    }

    @Override
    public void onParsed(ISecureProfile profile) {
        this.notifySecureProfilePresent(profile);
        this.handleResolved(profile);
    }

    private void handleResolved(ISecureProfile secureProfile) {
        boolean isDiscovered = this.cache.containsKey(secureProfile.getMacAddress());
        this.cache.put(secureProfile.getMacAddress(), secureProfile);
        if (!isDiscovered) {
            this.onDiscovered(secureProfile);
        } else {
            this.onUpdated();
        }
    }

    @Override
    public void evictInactiveDevices(long currentTimeMillis) {
        long inactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (ISecureProfile secureProfile : new ArrayList<ISecureProfile>(this.cache.values())) {
            long threshold;
            long timestamp = this.getSecureProfileTimestamp(secureProfile);
            if (timestamp == -1L || (threshold = currentTimeMillis - timestamp) <= inactivityTimeout) continue;
            this.cache.remove(secureProfile.getMacAddress());
            this.clearBeforeLost(secureProfile);
            this.onLost(secureProfile);
            this.removeSecureProfileTimestamp(secureProfile);
        }
    }

    private void notifySecureProfilePresent(ISecureProfile secureProfile) {
        this.secureProfileTimestampArray.put(secureProfile.getMacAddress().hashCode(), System.currentTimeMillis());
    }

    private void onDiscovered(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewDiscovered(secureProfile, System.currentTimeMillis()));
    }

    private void onUpdated() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastUpdateCallbackMillis > this.deviceUpdateIntervalCallback) {
            this.discoveryContract.onEvent(SecureProfileEvent.createNewUpdated(new ArrayList<ISecureProfile>(this.cache.values()), currentTimeMillis));
            this.lastUpdateCallbackMillis = currentTimeMillis;
        }
    }

    private void onLost(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewLost(secureProfile, System.currentTimeMillis()));
        this.parser.handleLostEvent(secureProfile);
    }

    private void clearBeforeLost(ISecureProfile secureProfile) {
        this.parser.clearRssiCalculation(secureProfile.getMacAddress().hashCode());
    }

    private long getSecureProfileTimestamp(ISecureProfile secureProfile) {
        return this.secureProfileTimestampArray.get(secureProfile.getMacAddress().hashCode(), -1L);
    }

    private void removeSecureProfileTimestamp(ISecureProfile secureProfile) {
        int index = this.secureProfileTimestampArray.indexOfKey(secureProfile.getMacAddress().hashCode());
        if (index >= 0) {
            this.secureProfileTimestampArray.removeAt(index);
        }
    }

    @Override
    public void disable() {
        this.parser.disable();
    }
}

