/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class BeaconDevice
implements IBeaconDevice {
    public static final Parcelable.Creator<BeaconDevice> CREATOR = new Parcelable.Creator<BeaconDevice>(){

        public BeaconDevice createFromParcel(Parcel in) {
            return new BeaconDevice(in);
        }

        public BeaconDevice[] newArray(int size) {
            return new BeaconDevice[size];
        }
    };
    private static final String PARCEL_RSSI = "rssi";
    private static final String PARCEL_ADDRESS = "parcel_address";
    private static final String PARCEL_TIMESTAMP = "parcel_timestamp";
    private static final String PARCEL_NAME = "parcel_name";
    private static final String SHUFFLED = "shuffled";
    private final HashCodeBuilder hashCodeBuilder;
    private String address;
    private UUID proximityUUID;
    private int major;
    private int minor;
    private int txPower;
    private String name;
    private String uniqueId;
    private String firmwareVersion;
    private int batteryPower;
    private boolean shuffled;
    private int rssi;
    private double distance;
    private Proximity proximity;
    private long timestamp;
    private byte[] password;

    private BeaconDevice(IBeaconDevice beaconDevice, ResolvedId resolvedId) {
        IBeaconId iBeaconId = resolvedId.getIBeaconId();
        this.proximityUUID = iBeaconId.getProximity();
        this.major = iBeaconId.getMajor();
        this.minor = iBeaconId.getMinor();
        this.uniqueId = resolvedId.getUniqueId();
        this.txPower = beaconDevice.getTxPower();
        this.distance = beaconDevice.getDistance();
        this.timestamp = beaconDevice.getTimestamp();
        this.firmwareVersion = beaconDevice.getFirmwareVersion();
        this.batteryPower = beaconDevice.getBatteryPower();
        this.proximity = beaconDevice.getProximity();
        this.rssi = beaconDevice.getRssi();
        this.address = beaconDevice.getAddress();
        this.name = beaconDevice.getName();
        this.shuffled = beaconDevice.isShuffled();
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    BeaconDevice(Parcel input) {
        Bundle bundle = input.readBundle(this.getClass().getClassLoader());
        this.rssi = bundle.getInt(PARCEL_RSSI);
        this.name = bundle.getString(PARCEL_NAME);
        this.address = bundle.getString(PARCEL_ADDRESS);
        this.proximityUUID = (UUID)bundle.getSerializable("proximity");
        this.major = bundle.getInt("major");
        this.minor = bundle.getInt("minor");
        this.txPower = bundle.getInt("txPower");
        this.distance = bundle.getDouble("accuracy");
        this.password = bundle.getByteArray("password");
        this.timestamp = bundle.getLong(PARCEL_TIMESTAMP);
        this.proximity = Proximity.fromDistance(this.distance);
        this.firmwareVersion = bundle.getString("firmware");
        this.uniqueId = bundle.getString("uniqueId");
        this.batteryPower = bundle.getInt("battery");
        this.shuffled = bundle.getBoolean(SHUFFLED, false);
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    BeaconDevice(Builder builder) {
        this.address = builder.address;
        this.proximityUUID = builder.proximityUUID;
        this.major = builder.major;
        this.minor = builder.minor;
        this.txPower = builder.txPower;
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.firmwareVersion = builder.firmwareVersion;
        this.batteryPower = builder.batteryPower;
        this.shuffled = builder.shuffled;
        this.rssi = builder.rssi;
        this.distance = builder.distance;
        this.proximity = builder.proximity;
        this.timestamp = builder.timestamp;
        this.password = builder.password;
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    public static BeaconDevice of(IBeaconDevice beaconDevice, ResolvedId resolvedId) {
        return new BeaconDevice(beaconDevice, resolvedId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel output, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putInt(PARCEL_RSSI, this.rssi);
        bundle.putString(PARCEL_ADDRESS, this.address);
        bundle.putString(PARCEL_NAME, this.name);
        bundle.putSerializable("proximity", (Serializable)this.proximityUUID);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putInt("txPower", this.txPower);
        bundle.putDouble("accuracy", this.distance);
        bundle.putByteArray("password", this.password);
        bundle.putLong(PARCEL_TIMESTAMP, this.timestamp);
        bundle.putString("firmware", this.firmwareVersion);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putInt("battery", this.batteryPower);
        bundle.putBoolean(SHUFFLED, this.shuffled);
        output.writeBundle(bundle);
    }

    @Override
    public int compareTo(IBeaconDevice another) {
        SDKPreconditions.checkNotNull(another, "Comparing to null beacon device!");
        return Integer.valueOf(this.hashCode()).compareTo(another.hashCode());
    }

    public int hashCode() {
        return this.hashCodeBuilder.append(this.address).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BeaconDevice)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BeaconDevice beaconDevice = (BeaconDevice)o;
        if (this.proximityUUID != null && beaconDevice.proximityUUID != null && !this.proximityUUID.equals(beaconDevice.proximityUUID)) {
            return false;
        }
        if (this.address != null && beaconDevice.address != null && !this.address.equals(beaconDevice.address)) {
            return false;
        }
        if (this.uniqueId != null && beaconDevice.uniqueId != null && !this.uniqueId.equals(beaconDevice.uniqueId)) {
            return false;
        }
        return this.minor == beaconDevice.minor && this.major == beaconDevice.major;
    }

    public String toString() {
        return "iBeaconDevice{address='" + this.address + '\'' + ", uniqueId='" + this.uniqueId + '\'' + ", proximityUUID=" + this.proximityUUID + ", major=" + this.major + ", minor=" + this.minor + ", rssi=" + this.rssi + ", shuffled=" + this.shuffled + '}';
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    public void setProximity(Proximity proximity) {
        this.proximity = proximity;
    }

    @Override
    public int getBatteryPower() {
        return this.batteryPower;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public DeviceProfile getProfile() {
        return DeviceProfile.IBEACON;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(byte[] password) {
        SDKPreconditions.checkNotNull(password, "Password is null");
        int passwordLength = password.length;
        this.password = new byte[passwordLength];
        System.arraycopy(password, 0, this.password, 0, passwordLength);
    }

    @Override
    public Model getModel() {
        return Model.UNKNOWN;
    }

    @Override
    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    public static class Builder {
        String address;
        UUID proximityUUID;
        int major;
        int minor;
        int txPower;
        String name;
        String uniqueId;
        String firmwareVersion;
        int batteryPower;
        boolean shuffled;
        int rssi;
        double distance;
        Proximity proximity;
        long timestamp;
        byte[] password;

        public Builder() {
        }

        public Builder(IBeaconDevice device) {
            this.address = device.getAddress();
            this.proximityUUID = device.getProximityUUID();
            this.major = device.getMajor();
            this.minor = device.getMinor();
            this.txPower = device.getTxPower();
            this.name = device.getName();
            this.uniqueId = device.getUniqueId();
            this.firmwareVersion = device.getFirmwareVersion();
            this.batteryPower = device.getBatteryPower();
            this.shuffled = device.isShuffled();
            this.rssi = device.getRssi();
            this.distance = device.getDistance();
            this.proximity = device.getProximity();
            this.timestamp = device.getTimestamp();
            this.password = device.getPassword();
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder proximityUUID(UUID proximityUUID) {
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder txPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder firmwareRevision(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder batteryPower(int batteryPower) {
            this.batteryPower = batteryPower;
            return this;
        }

        public Builder shuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder rssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder proximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder password(byte[] password) {
            SDKPreconditions.checkNotNull(password, "Password is null");
            int passwordLength = password.length;
            this.password = new byte[passwordLength];
            System.arraycopy(password, 0, this.password, 0, passwordLength);
            return this;
        }

        public BeaconDevice build() {
            return new BeaconDevice(this);
        }
    }
}

