/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import java.util.concurrent.TimeUnit;

public final class ActivityCheckConfiguration {
    public static final ActivityCheckConfiguration DISABLED = new ActivityCheckConfiguration(-1L, -1L);
    public static final ActivityCheckConfiguration MINIMAL = new ActivityCheckConfiguration(TimeUnit.SECONDS.toMillis(3L), TimeUnit.SECONDS.toMillis(1L));
    public static final ActivityCheckConfiguration DEFAULT = new ActivityCheckConfiguration(TimeUnit.SECONDS.toMillis(10L), TimeUnit.SECONDS.toMillis(5L));
    private final long inactivityTimeout;
    private final long checkPeriod;

    public static ActivityCheckConfiguration create(long inactivityTimeout, long checkPeriod) {
        return new ActivityCheckConfiguration(inactivityTimeout, checkPeriod);
    }

    private ActivityCheckConfiguration(long inactivityTimeout, long checkPeriod) {
        this.inactivityTimeout = inactivityTimeout;
        this.checkPeriod = checkPeriod;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityCheckConfiguration that = (ActivityCheckConfiguration)o;
        if (this.inactivityTimeout != that.inactivityTimeout) {
            return false;
        }
        return this.checkPeriod == that.checkPeriod;
    }

    public int hashCode() {
        int result = (int)(this.inactivityTimeout ^ this.inactivityTimeout >>> 32);
        result = 31 * result + (int)(this.checkPeriod ^ this.checkPeriod >>> 32);
        return result;
    }
}

