package com.kontakt.sdk.android.common.model;

import android.os.Parcel;

/**
 * Model class that provides information about place's coordinates.
 */
public class PlaceCoordinates implements Coordinates {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Creator<PlaceCoordinates> CREATOR = new Creator<PlaceCoordinates>() {
    @Override
    public PlaceCoordinates createFromParcel(Parcel source) {
      return new PlaceCoordinates(source);
    }

    @Override
    public PlaceCoordinates[] newArray(int size) {
      return new PlaceCoordinates[size];
    }
  };

  private final double x1;
  private final double y1;
  private final double x2;
  private final double y2;

  public PlaceCoordinates(double x1, double y1, double x2, double y2) {
    this.x1 = x1;
    this.y1 = y1;
    this.x2 = x2;
    this.y2 = y2;
  }

  protected PlaceCoordinates(Parcel in) {
    this.x1 = in.readDouble();
    this.y1 = in.readDouble();
    this.x2 = in.readDouble();
    this.y2 = in.readDouble();
  }

  public double getX1() {
    return x1;
  }

  public double getY1() {
    return y1;
  }

  public double getX2() {
    return x2;
  }

  public double getY2() {
    return y2;
  }

  @Override
  public Type getType() {
    return Type.PLACE;
  }

  @Override
  public String toString() {
    return x1 + ":" + y1 + "," + x2 + ":" + y2;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    PlaceCoordinates that = (PlaceCoordinates) o;

    if (Double.compare(that.x1, x1) != 0) return false;
    if (Double.compare(that.y1, y1) != 0) return false;
    if (Double.compare(that.x2, x2) != 0) return false;
    return Double.compare(that.y2, y2) == 0;
  }

  @Override
  public int hashCode() {
    int result;
    long temp;
    temp = Double.doubleToLongBits(x1);
    result = (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y1);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(x2);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y2);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    return result;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeDouble(this.x1);
    dest.writeDouble(this.y1);
    dest.writeDouble(this.x2);
    dest.writeDouble(this.y2);
  }
}
