package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of device model.
 */
public enum Model {

  /**
   * Smart beacon device model.
   */
  SMART_BEACON(1),

  /**
   * USB beacon device model.
   */
  USB_BEACON(3),

  /**
   * Card beacon device model.
   */
  CARD_BEACON(4),

  /**
   * Gateway device model.
   */
  GATEWAY(5),

  /**
   * Beacon PRO device model.
   */
  BEACON_PRO(6),

  /**
   * PROBE device model.
   */
  PROBE(7),

  /**
   * Tag beacon device model.
   */
  TAG_BEACON(8),

  /**
   * Sensor beacon device model.
   */
  SENSOR_BEACON(-1),

  /**
   * Cloud beacon device model.
   */
  CLOUD_BEACON(-1),

  /**
   * External device model.
   */
  EXTERNAL(-1),

  UNKNOWN(-1);

  private int code;

  Model(int code) {
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  public static Model fromString(String modelString) {
    if (modelString != null) {
      for (Model model : Model.values()) {
        if (modelString.equalsIgnoreCase(model.name())) {
          return model;
        }
      }
    }
    return SMART_BEACON;
  }

  public static Model fromCode(int code) {
    if (code <= 0) {
      return UNKNOWN;
    }
    for (Model model : Model.values()) {
      if (model.getCode() == code) {
        return model;
      }
    }
    return UNKNOWN;
  }
}
