package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Triggers;
import com.kontakt.sdk.android.common.model.Trigger;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.QueryMap;

public interface TriggersService {

  @GET("/trigger")
  Call<Triggers> getTrigger(@QueryMap Map<String, String> params);

  @GET("/trigger")
  Call<Triggers> getTriggers(@QueryMap Map<String, String> params);

  @GET("/trigger")
  Call<Triggers> getTriggers(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @FormUrlEncoded
  @POST("/trigger/create")
  Call<Trigger> create(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/trigger/update")
  Call<String> update(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/trigger/delete")
  Call<String> delete(@FieldMap Map<String, String> params);
}
