package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Receivers;
import com.kontakt.sdk.android.common.model.Receiver;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.QueryMap;

public interface ReceiversService {

  @GET("/receiver")
  Call<Receivers> getReceivers(@QueryMap Map<String, String> params);

  @GET("/receiver")
  Call<Receivers> getReceivers(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @FormUrlEncoded
  @POST("/receiver/create")
  Call<Receiver> createReceiver(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/receiver/update")
  Call<String> updateReceiver(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/receiver/delete")
  Call<String> deleteReceiver(@FieldMap Map<String, String> params);

}
