package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Places;
import com.kontakt.sdk.android.common.model.Place;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface PlacesService {

  @GET("/place")
  Call<Places> getPlaces(@QueryMap Map<String, String> params);

  @GET("/place")
  Call<Places> getPlaces(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/place/{id}/schema")
  Call<ResponseBody> getPlaceSchemaImage(@Path("id") String id);

  @FormUrlEncoded
  @POST("/place/create")
  Call<Place> createPlace(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/place/update")
  Call<String> updatePlace(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/place/delete")
  Call<String> deletePlace(@FieldMap Map<String, String> params);

}
