package com.kontakt.sdk.android.cloud.api.executor.receivers;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.ReceiversApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ReceiversService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link ReceiversApi}. Use this class if you want to delete
 * receivers through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   kontaktCloud.receivers().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteReceiverRequestExecutor extends RequestExecutor<String> {

  private final ReceiversService receiversService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and receiver's identifier.
   *
   * @param receiversService the receivers API service.
   * @param id the receiver's identifier.
   */
  public DeleteReceiverRequestExecutor(ReceiversService receiversService, UUID id) {
    this.receiversService = receiversService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return receiversService.deleteReceiver(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Receivers.RECEIVER_ID_PARAMETER, id.toString());
    return params;
  }
}
