package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class FirmwareFileFromUrlRequestExecutor extends FileRequestExecutor {

  private final FirmwaresService firmwaresService;
  private final String url;

  /**
   * Constructs request executor initialized with corresponding service class and url.
   *
   * @param firmwaresService the firmwares API service.
   * @param url the url.
   */
  public FirmwareFileFromUrlRequestExecutor(final FirmwaresService firmwaresService, final String url) {
    this.firmwaresService = firmwaresService;
    this.url = url;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileData execute() throws IOException, KontaktCloudException {
    checkPreconditions();
    return super.execute();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(CloudCallback<FileData> callback) {
    checkPreconditions();
    super.execute(callback);
  }

  private void checkPreconditions() {
    SDKPreconditions.checkState(url != null, "cannot get firmware - specify url");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<ResponseBody> prepareCall() {
    return firmwaresService.getFirmwareFileFromUrl(url);
  }
}
