package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.api.ActionsApi;
import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Call;

/**
 * Request executor provided by {@link ActionsApi}. Use this class if you want to fetch content
 * action files, for example:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   FileData file = kontaktCloud.actions().fileOf(actionId).execute();
 *   </code>
 * </pre>
 */
public class ContentActionFileRequestExecutor extends FileRequestExecutor {

  private final ActionsService actionsService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and action's id.
   *
   * @param actionsService the actions API service.
   * @param id the action's unique identifier.
   */
  public ContentActionFileRequestExecutor(final ActionsService actionsService, final UUID id) {
    this.actionsService = actionsService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<ResponseBody> prepareCall() {
    return actionsService.getContentActionFile(id.toString());
  }
}
