package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
interface BleScanCallback extends BluetoothAdapter.LeScanCallback, ListenerCollector, ListenerAccessor, Closeable {

  /**
   * Default scan callback.
   */
  BleScanCallback DEFAULT = new BleScanCallback() {
    private final ConcurrentHashMap<Integer, InternalProximityListener> monitoringListenerMap = new ConcurrentHashMap<>();

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
      return Collections.unmodifiableCollection(new ArrayList<>(monitoringListenerMap.values()));
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
      monitoringListenerMap.put(System.identityHashCode(proximityListener), proximityListener);
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
      monitoringListenerMap.remove(System.identityHashCode(proximityListener), proximityListener);
    }

    @Override
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {

    }

    @Override
    public void close() throws IOException {
      monitoringListenerMap.clear();
    }
  };
}
