package com.kontakt.sdk.android.ble.security;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.TerminatingProperty;
import java.nio.ByteBuffer;
import java.util.List;

public class WriteRequest extends Packet {
  public static final byte PADDING_BYTE = (byte) 0xA5;
  private static final int DESCRIPTOR_LENGTH = 3; //Field length + PID
  private List<AbstractProperty<?>> properties;

  public WriteRequest(int token, List<AbstractProperty<?>> properties) {
    super(Flag.REQUEST, Operation.WRITE, token);
    this.properties = properties;
  }

  protected WriteRequest(int token, Flag flag, List<AbstractProperty<?>> properties) {
    super(flag, Operation.WRITE, token);
    this.properties = properties;
  }

  @Override
  protected byte[] getPayload() {
    short length = 0;
    for (AbstractProperty property : properties) {
      length += DESCRIPTOR_LENGTH;
      length += property.getSize();
    }

    length += DESCRIPTOR_LENGTH; //Terminating PID
    ByteBuffer buffer = ByteBuffer.allocate(length);
    for (AbstractProperty property : properties) {
      buffer.put(property.getData());
    }
    buffer.put(new TerminatingProperty().getData());
    return buffer.array();
  }
}
