package com.kontakt.sdk.android.ble.security;

public enum ResponseCode {
  OK(0x00),
  INVALID_FORMAT(0x01),
  OPERATION_NOT_SUPPORTED(0x02),
  AUTHORIZATION_FAILED(0x03),
  VERIFICATION_FAILED(0x04),
  ID_NOT_FOUND(0x05),
  TOO_MUCH_DATA_REQUESTED(0x06),
  TOKEN_EXPIRED(0x07);

  private byte value;

  ResponseCode(int value) {
    this.value = (byte) value;
  }

  public byte getValue() {
    return value;
  }

  public static ResponseCode of(byte value) {
    ResponseCode[] arr = values();
    int len = arr.length;

    for (int i = 0; i < len; i++) {
      if (arr[i].getValue() == value) {
        return arr[i];
      }
    }
    throw new IllegalArgumentException("Invalid response code.");
  }
}
