package com.kontakt.sdk.android.ble.security;

public enum Flag {
  NONE(0x00),
  ENCRYPTED(0x01),
  REQUEST(0x02),
  ENCRYPTED_REQUEST(0x03);

  private byte value;

  Flag(int value) {
    this.value = (byte) value;
  }

  public byte getValue() {
    return value;
  }

  public static Flag of(byte value) {
    Flag[] arr = values();
    int len = arr.length;

    for (int i = 0; i < len; i++) {
      if (arr[i].getValue() == value) {
        return arr[i];
      }
    }
    return null;
  }
}
