package com.kontakt.sdk.android.ble.security;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import java.util.List;

public class EncryptedWriteRequest extends WriteRequest {
  private final String password;

  public EncryptedWriteRequest(int token, List<AbstractProperty<?>> properties, String password) {
    super(token, Flag.ENCRYPTED_REQUEST, properties);
    this.password = password;
  }

  @Override
  protected byte[] getPayload() {
    byte[] dataToEncrypt = super.getPayload();
    dataToEncrypt = PayloadEncrypter.align(dataToEncrypt, 16, null);
    return PayloadEncrypter.encryptPayload(dataToEncrypt, password, token);
  }
}
