package com.kontakt.sdk.android.ble.manager.listeners.simple;

import com.kontakt.sdk.android.ble.manager.listeners.SpaceListener;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;

public abstract class IBeaconSpaceListener implements SpaceListener {

  public abstract void onRegionEntered(IBeaconRegion region);

  public abstract void onRegionAbandoned(IBeaconRegion region);

  @Override
  public void onNamespaceEntered(IEddystoneNamespace namespace) {
    //Noop
  }

  @Override
  public void onNamespaceAbandoned(IEddystoneNamespace namespace) {
    //Noop
  }
}
