package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.exception.ScanError;

/**
 * Listener used to inform when devices scanning is started and stopped.
 */
public interface ScanStatusListener {

  /**
   * Callback invoked when scanning is started.
   */
  void onScanStart();

  /**
   * Callback invoked when scanning is stopped.
   */
  void onScanStop();

  /**
   * Callback invoked when scanning error occured.
   *
   * @param scanError ScanError
   */
  void onScanError(ScanError scanError);

  /**
   * Called when monitoring cycle starts. Invoked only if {@link ScanPeriod} set is different than {@link ScanPeriod#RANGING};
   */
  void onMonitoringCycleStart();

  /**
   * Called when monitoring cycle ends. Invoked only if {@link ScanPeriod} set is different than {@link ScanPeriod#RANGING};
   */
  void onMonitoringCycleStop();
}
