package com.kontakt.sdk.android.ble.filter.eddystone;

import com.android.internal.util.Predicate;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;

/**
 * Filters are designed to enable more detailed devices search and thus reduce battery consumption.
 *
 * Predicate accepting Eddystone's specific UID advertising packet.
 * The packet has the following structure:
 * <ul>
 * <li>[0]..[9] - namespace id bytes</li>
 * <li>[10]..[15] - instance id bytes</li>
 * </ul>
 */
public interface EddystoneFilter extends Predicate<IEddystoneDevice> {
}
