package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("WeakerAccess")
public class IBeaconDeviceEvent extends AbstractBluetoothDeviceEvent {

  private final IBeaconRegion region;

  /**
   * The Parcelable constant CREATOR.
   */
  public static final Parcelable.Creator<IBeaconDeviceEvent> CREATOR = new Parcelable.Creator<IBeaconDeviceEvent>() {
    @Override
    public IBeaconDeviceEvent createFromParcel(Parcel source) {
      Bundle bundle = source.readBundle(getClass().getClassLoader());

      BeaconRegion iBeaconRegion = bundle.getParcelable("region");
      EventType eventType = (EventType) bundle.getSerializable(PARCELABLE_EVENT_TYPE);
      ArrayList<IBeaconDevice> deviceList = bundle.getParcelableArrayList(PARCELABLE_DEVICE_LIST);
      long timestamp = bundle.getLong(PARCELABLE_TIMESTAMP);

      return new IBeaconDeviceEvent(eventType, iBeaconRegion, deviceList, timestamp);
    }

    @Override
    public IBeaconDeviceEvent[] newArray(int size) {
      return new IBeaconDeviceEvent[size];
    }
  };

  /**
   * Creates IBeaconDeviceEvent from other event with provided list of devices
   *
   * @param event the event
   * @param devices the devices
   * @return new event
   */
  public static IBeaconDeviceEvent of(IBeaconDeviceEvent event, List<IBeaconDevice> devices) {
    return new IBeaconDeviceEvent(event.getEventType(), event.getRegion(), devices, event.getTimestamp());
  }

  /**
   * Instantiates a new iBeacon device event.
   *
   * @param eventType the event type
   * @param iBeaconRegion the iBeaconRegion
   * @param iBeaconDeviceList the iBeacon device list
   */
  public IBeaconDeviceEvent(EventType eventType, IBeaconRegion iBeaconRegion, List<IBeaconDevice> iBeaconDeviceList) {
    this(eventType, iBeaconRegion, iBeaconDeviceList, System.currentTimeMillis());
  }

  IBeaconDeviceEvent(EventType eventType, IBeaconRegion region, List<IBeaconDevice> iBeaconDevices, long timestamp) {
    super(eventType, DeviceProfile.IBEACON, iBeaconDevices, timestamp);
    this.region = region;
  }

  @Override
  public List<IBeaconDevice> getDeviceList() {
    return (List<IBeaconDevice>) super.getDeviceList();
  }

  /**
   * Gets iBeacon region.
   *
   * @return the region
   */
  public IBeaconRegion getRegion() {
    return region;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    Bundle bundle = new Bundle(getClass().getClassLoader());
    bundle.putSerializable(PARCELABLE_EVENT_TYPE, eventType);
    bundle.putLong(PARCELABLE_TIMESTAMP, timestamp);
    bundle.putParcelableArrayList(PARCELABLE_DEVICE_LIST, (ArrayList<? extends Parcelable>) deviceList);
    bundle.putParcelable("region", region);

    dest.writeBundle(bundle);
  }
}
