package com.kontakt.sdk.android.ble.discovery;

import java.util.HashMap;
import java.util.Map;

public class FramePayload {

  private final String address;
  private final Map<FrameDataType, byte[]> data;

  public FramePayload(final String address, final Map<FrameDataType, byte[]> data) {
    this(address);
    this.data.putAll(data);
  }

  public FramePayload(final String address) {
    this.address = address;
    this.data = new HashMap<>();
  }

  public String getAddress() {
    return address;
  }

  public byte[] getData(final FrameDataType frameDataType) {
    return data.get(frameDataType);
  }

  public void addData(final FrameDataType frameDataType, byte[] payload) {
    data.put(frameDataType, payload);
  }

}
