package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.exception.ScanError;

/**
 * Interface representing Discovery contract.
 */
public interface DiscoveryContract {

  /**
   * Notifies that the scan has started.
   */
  void onMonitorCycleStart();

  /**
   * Notifires that the scan has stopped.
   */
  void onMonitorCycleStop();

  /**
   * Notifies about specific event occurence.
   *
   * @param event the event
   */
  void onEvent(BluetoothDeviceEvent event);

  /**
   * Notifies about scan failure.
   *
   * @param exception the exception.
   */
  void onScanError(ScanError exception);

}
