package com.kontakt.sdk.android.ble.connection;

import android.bluetooth.BluetoothGattDescriptor;

/**
 * WriteDescriptorListener provides callbacks indicating whether Beacon descriptor manipulation
 * ended successfully or failed.
 */
public interface WriteDescriptorListener {

  void onDescriptorWriteSuccess(BluetoothGattDescriptor descriptor);

  void onDescriptorWriteFailure(BluetoothGattDescriptor descriptor);

  WriteDescriptorListener NOOP_LISTENER = new WriteDescriptorListener() {
    @Override
    public void onDescriptorWriteSuccess(BluetoothGattDescriptor descriptor) {

    }

    @Override
    public void onDescriptorWriteFailure(BluetoothGattDescriptor descriptor) {

    }
  };
}