package com.kontakt.sdk.android.ble.connection;

import android.content.Context;
import android.os.RemoteException;

import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

import static com.kontakt.sdk.android.ble.util.DeviceUtils.isSecure;

final class GattControllerFactory {

  static GattController createGattController(Context context,
                                             KontaktDeviceConnectionImpl kontaktDeviceConnection,
                                             RemoteBluetoothDevice remoteBluetoothDevice) throws RemoteException {
    if (isSecure(remoteBluetoothDevice)) {
      return new SecureGattController(kontaktDeviceConnection, context, remoteBluetoothDevice);
    }

    throw new IllegalStateException("Device you are trying to connect to has unsupported firmware version.");
  }
}
