package com.kontakt.sdk.android.ble.connection;

import android.bluetooth.BluetoothGattCharacteristic;

/**
 * ChangeListener provides callbacks indicating whether Beacon characteristics has changed.
 */
public interface ChangeCharacteristicListener {

  void onCharacteristicChanged(BluetoothGattCharacteristic characteristic);

  ChangeCharacteristicListener NOOP_LISTENER = new ChangeCharacteristicListener() {
    @Override
    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
      //No Operation listener
    }
  };
}