/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.notifications;

import android.content.Context;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.NotificationsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class RegisterTokenRequestExecutor
extends RequestExecutor<Void> {
    private static final String PLATFORM_NAME = "ANDROID";
    private final NotificationsService notificationsService;
    private final String token;
    private Context context;
    private boolean sandbox;

    public RegisterTokenRequestExecutor(NotificationsService notificationsService, String token) {
        this.notificationsService = notificationsService;
        this.token = token;
    }

    public RegisterTokenRequestExecutor withContext(Context context) {
        this.context = SDKPreconditions.checkNotNull(context, "context cannot be null");
        return this;
    }

    public RegisterTokenRequestExecutor forSandbox(boolean sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    @Override
    public Void execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Void)super.execute();
    }

    @Override
    public void execute(CloudCallback<Void> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Void> prepareCall() {
        return this.notificationsService.registerToken(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.context != null, "cannot register token - specify context");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.token);
        params.put("platform", PLATFORM_NAME);
        params.put("bundleId", this.context.getApplicationContext().getPackageName());
        params.put("sandbox", String.valueOf(this.sandbox));
        return params;
    }
}

