/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.cloud.adapter.ConfigTypeAdapter;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.model.Shuffles;
import com.kontakt.sdk.android.common.model.Specification;
import com.kontakt.sdk.android.common.model.SubscriptionPlan;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DeviceTypeAdapter
extends BaseTypeAdapter<Device> {
    private final ConfigTypeAdapter configTypeAdapter = new ConfigTypeAdapter();

    public void write(JsonWriter out, Device device) throws IOException {
        out = out.beginObject();
        this.writeString(out, "uniqueId", device.getUniqueId());
        this.writeUUID(out, "id", device.getId());
        this.writeFutureId(out, device.getShuffles());
        this.writeString(out, "mac", device.getMac());
        this.writeUUID(out, "secureProximity", device.getSecureProximity());
        this.writeString(out, "secureNamespace", device.getSecureNamespace());
        this.writeConfig(out, device.getConfig());
        this.writeString(out, "firmware", device.getFirmware());
        this.writeString(out, "alias", device.getAlias());
        this.writeTags(out, device.getTags());
        this.writeEnum(out, "deviceType", device.getDeviceType());
        this.writeEnum(out, "specification", device.getSpecification());
        this.writeEnum(out, "model", device.getModel());
        this.writeUUID(out, "managerId", device.getManagerId());
        this.writeVenue(out, device.getVenue());
        this.writeInteger(out, "actionsCount", device.getActionsCount());
        this.writeEnum(out, "access", device.getAccess());
        this.writeString(out, "lat", device.getLatitude());
        this.writeString(out, "lat", device.getLongitude());
        this.writeSubscriptionPlans(out, device.getSubscriptionPlans());
        this.writeString(out, "orderId", device.getOrderId());
        out.endObject();
    }

    public Device read(JsonReader in) throws IOException {
        Device.Builder deviceBuilder = new Device.Builder();
        Config.Builder configBuilder = new Config.Builder();
        in.beginObject();
        block80: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "uniqueId": {
                    String uniqueId = in.nextString();
                    deviceBuilder.uniqueId(uniqueId);
                    configBuilder.uniqueId(uniqueId);
                    continue block80;
                }
                case "id": {
                    UUID id = UUID.fromString(in.nextString());
                    deviceBuilder.id(id);
                    continue block80;
                }
                case "venue": {
                    Venue venue = this.readVenue(in);
                    deviceBuilder.venue(venue);
                    continue block80;
                }
                case "futureId": {
                    Shuffles shuffles = this.readShuffles(in);
                    deviceBuilder.shuffles(shuffles);
                    continue block80;
                }
                case "mac": {
                    String mac = in.nextString();
                    deviceBuilder.mac(mac);
                    continue block80;
                }
                case "secureProximity": {
                    UUID secureProximity = UUID.fromString(in.nextString());
                    deviceBuilder.secureProximity(secureProximity);
                    continue block80;
                }
                case "secureNamespace": {
                    String secureNamespace = in.nextString();
                    deviceBuilder.secureNamespace(secureNamespace);
                    continue block80;
                }
                case "firmware": {
                    String firmware = in.nextString();
                    deviceBuilder.firmware(firmware);
                    continue block80;
                }
                case "alias": {
                    String alias = in.nextString();
                    deviceBuilder.alias(alias);
                    continue block80;
                }
                case "tags": {
                    List<String> tags = this.readTags(in);
                    deviceBuilder.tags(tags);
                    continue block80;
                }
                case "deviceType": {
                    DeviceType deviceType = DeviceType.valueOf(in.nextString());
                    deviceBuilder.deviceType(deviceType);
                    continue block80;
                }
                case "specification": {
                    Specification specification = Specification.valueOf(in.nextString());
                    deviceBuilder.specification(specification);
                    continue block80;
                }
                case "model": {
                    Model model = Model.valueOf(in.nextString());
                    deviceBuilder.model(model);
                    continue block80;
                }
                case "subscriptionPlans": {
                    List<SubscriptionPlan> subscriptionPlans = this.readSubscriptionPlans(in);
                    deviceBuilder.subscriptionPlans(subscriptionPlans);
                    continue block80;
                }
                case "managerId": {
                    UUID managerId = UUID.fromString(in.nextString());
                    deviceBuilder.managerId(managerId);
                    continue block80;
                }
                case "actionsCount": {
                    int actionsCount = in.nextInt();
                    deviceBuilder.actionsCount(actionsCount);
                    continue block80;
                }
                case "access": {
                    Access access = Access.valueOf(in.nextString());
                    deviceBuilder.access(access);
                    continue block80;
                }
                case "lat": {
                    String lat = in.nextString();
                    deviceBuilder.latitude(lat);
                    continue block80;
                }
                case "lng": {
                    String lng = in.nextString();
                    deviceBuilder.longitude(lng);
                    continue block80;
                }
                case "queriedBy": {
                    String queriedBy = in.nextString();
                    deviceBuilder.queriedBy(queriedBy);
                    continue block80;
                }
                case "orderId": {
                    String orderId = in.nextString();
                    deviceBuilder.orderId(orderId);
                    continue block80;
                }
                case "proximity": {
                    UUID proximity = UUID.fromString(in.nextString());
                    configBuilder.proximity(proximity);
                    continue block80;
                }
                case "major": {
                    int major = in.nextInt();
                    configBuilder.major(major);
                    continue block80;
                }
                case "minor": {
                    int minor = in.nextInt();
                    configBuilder.minor(minor);
                    continue block80;
                }
                case "txPower": {
                    int txPower = in.nextInt();
                    configBuilder.txPower(txPower);
                    continue block80;
                }
                case "interval": {
                    int interval = in.nextInt();
                    configBuilder.interval(interval);
                    continue block80;
                }
                case "namespace": {
                    String namespace = in.nextString();
                    configBuilder.namespace(namespace);
                    continue block80;
                }
                case "url": {
                    String url = in.nextString();
                    configBuilder.url(url);
                    continue block80;
                }
                case "instanceId": {
                    String instanceId = in.nextString();
                    configBuilder.instanceId(instanceId);
                    continue block80;
                }
                case "profiles": {
                    List<DeviceProfile> profiles = this.configTypeAdapter.readProfiles(in);
                    configBuilder.profiles(profiles);
                    continue block80;
                }
                case "packets": {
                    List<PacketType> packets = this.configTypeAdapter.readPackets(in);
                    configBuilder.packets(packets);
                    continue block80;
                }
                case "shuffled": {
                    boolean shuffled = in.nextBoolean();
                    configBuilder.shuffled(shuffled);
                    continue block80;
                }
                case "name": {
                    String name = in.nextString();
                    configBuilder.name(name);
                    continue block80;
                }
                case "password": {
                    String password = in.nextString();
                    configBuilder.password(password);
                    continue block80;
                }
                case "powerSaving": {
                    configBuilder.powerSaving(this.configTypeAdapter.readPowerSaving(in));
                    continue block80;
                }
                case "rssi1m": {
                    configBuilder.rssi1m(this.configTypeAdapter.readRssiCalibration(in));
                    continue block80;
                }
                case "rssi0m": {
                    configBuilder.rssi0m(this.configTypeAdapter.readRssiCalibration(in));
                    continue block80;
                }
                case "temperatureOffset": {
                    int temperatureOffset = in.nextInt();
                    configBuilder.temperatureOffset(temperatureOffset);
                    continue block80;
                }
            }
            in.skipValue();
        }
        in.endObject();
        deviceBuilder.config(configBuilder.build());
        return deviceBuilder.build();
    }

    private void writeConfig(JsonWriter out, Config config) throws IOException {
        if (config == null) {
            return;
        }
        this.configTypeAdapter.write(out, config);
    }

    private void writeFutureId(JsonWriter out, Shuffles shuffles) throws IOException {
        out.name("futureId");
        if (shuffles == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        this.writeEddystoneUids(out, shuffles.getEddystoneShuffles());
        this.writeIBeaconIds(out, shuffles.getIBeaconShuffles());
        out.endObject();
    }

    private void writeEddystoneUids(JsonWriter out, List<EddystoneUid> eddystoneUids) throws IOException {
        out.name("EDDYSTONE");
        if (eddystoneUids == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (EddystoneUid eddystoneUID : eddystoneUids) {
            this.writeEddystoneUid(out, eddystoneUID);
        }
        out.endArray();
    }

    private void writeEddystoneUid(JsonWriter out, EddystoneUid eddystoneUid) throws IOException {
        out.beginObject();
        this.writeString(out, "namespace", eddystoneUid.getNamespace());
        this.writeString(out, "instanceId", eddystoneUid.getInstanceId());
        out.endObject();
    }

    private void writeIBeaconIds(JsonWriter out, List<IBeaconId> iBeaconIds) throws IOException {
        out.name("IBEACON");
        if (iBeaconIds == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (IBeaconId iBeaconid : iBeaconIds) {
            this.writeIBeaconId(out, iBeaconid);
        }
        out.endArray();
    }

    private void writeIBeaconId(JsonWriter out, IBeaconId iBeaconId) throws IOException {
        out.beginObject();
        this.writeUUID(out, "proximity", iBeaconId.getProximity());
        this.writeInteger(out, "major", iBeaconId.getMajor());
        this.writeInteger(out, "minor", iBeaconId.getMinor());
        out.endObject();
    }

    private void writeVenue(JsonWriter out, Venue venue) throws IOException {
        out.name("venue");
        if (venue == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        this.writeString(out, "name", venue.getName());
        this.writeString(out, "description", venue.getDescription());
        this.writeUUID(out, "id", venue.getId());
        this.writeString(out, "coverType", venue.getCoverType());
        this.writeString(out, "image", venue.getImageUrl());
        this.writeEnum(out, "access", venue.getAccess());
        this.writeInteger(out, "devicesCount", venue.getDevicesCount());
        this.writeString(out, "lat", venue.getLatitude());
        this.writeString(out, "lng", venue.getLongitude());
        out.endObject();
    }

    private void writeTags(JsonWriter out, List<String> tags) throws IOException {
        out.name("tags");
        if (tags == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (String tag : tags) {
            out.value(tag);
        }
        out.endArray();
    }

    private void writeSubscriptionPlans(JsonWriter out, List<SubscriptionPlan> subscriptionPlans) throws IOException {
        out.name("subscriptionPlans");
        if (subscriptionPlans == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (SubscriptionPlan subscriptionPlan : subscriptionPlans) {
            out.value(subscriptionPlan.name());
        }
        out.endArray();
    }

    private Shuffles readShuffles(JsonReader in) throws IOException {
        Shuffles.Builder builder = new Shuffles.Builder();
        in.beginObject();
        block8: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "EDDYSTONE": {
                    List<EddystoneUid> eddystoneUIDs = this.readFutureEddystoneUids(in);
                    builder.eddystoneShuffles(eddystoneUIDs);
                    continue block8;
                }
                case "IBEACON": {
                    List<IBeaconId> iBeaconIds = this.readFutureIBeaconIds(in);
                    builder.ibeaconShuffles(iBeaconIds);
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return builder.build();
    }

    private List<EddystoneUid> readFutureEddystoneUids(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<EddystoneUid> eddystoneUids = new ArrayList<EddystoneUid>();
        while (in.hasNext()) {
            EddystoneUid eddystoneUID = this.readEddystoneUid(in);
            eddystoneUids.add(eddystoneUID);
        }
        in.endArray();
        return eddystoneUids;
    }

    private EddystoneUid readEddystoneUid(JsonReader in) throws IOException {
        String namespace = null;
        String instanceId = null;
        in.beginObject();
        block8: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "namespace": {
                    namespace = in.nextString();
                    continue block8;
                }
                case "instanceId": {
                    instanceId = in.nextString();
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        EddystoneUid eddystoneUid = EddystoneUid.of(namespace, instanceId);
        return eddystoneUid;
    }

    private List<IBeaconId> readFutureIBeaconIds(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<IBeaconId> iBeaconIds = new ArrayList<IBeaconId>();
        while (in.hasNext()) {
            IBeaconId iBeaconId = this.readIBeaconId(in);
            iBeaconIds.add(iBeaconId);
        }
        in.endArray();
        return iBeaconIds;
    }

    private IBeaconId readIBeaconId(JsonReader in) throws IOException {
        UUID proximity = null;
        int major = 0;
        int minor = 0;
        in.beginObject();
        block10: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "proximity": {
                    proximity = UUID.fromString(in.nextString());
                    continue block10;
                }
                case "major": {
                    major = in.nextInt();
                    continue block10;
                }
                case "minor": {
                    minor = in.nextInt();
                    continue block10;
                }
            }
            in.skipValue();
        }
        in.endObject();
        IBeaconId iBeaconId = IBeaconId.of(proximity, major, minor);
        return iBeaconId;
    }

    private Venue readVenue(JsonReader in) throws IOException {
        Venue.Builder venueBuilder = new Venue.Builder();
        in.beginObject();
        block22: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "id": {
                    UUID id = UUID.fromString(in.nextString());
                    venueBuilder.id(id);
                    continue block22;
                }
                case "name": {
                    String name = in.nextString();
                    venueBuilder.name(name);
                    continue block22;
                }
                case "description": {
                    String description = in.nextString();
                    venueBuilder.description(description);
                    continue block22;
                }
                case "coverType": {
                    String coverType = in.nextString();
                    venueBuilder.coverType(coverType);
                    continue block22;
                }
                case "image": {
                    String imageUrl = in.nextString();
                    venueBuilder.imageUrl(imageUrl);
                    continue block22;
                }
                case "access": {
                    Access access = Access.valueOf(in.nextString());
                    venueBuilder.access(access);
                    continue block22;
                }
                case "devicesCount": {
                    int devicesCount = in.nextInt();
                    venueBuilder.devicesCount(devicesCount);
                    continue block22;
                }
                case "lat": {
                    String lat = in.nextString();
                    venueBuilder.latitude(lat);
                    continue block22;
                }
                case "lng": {
                    String lng = in.nextString();
                    venueBuilder.longitude(lng);
                    continue block22;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return venueBuilder.build();
    }

    List<String> readTags(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<String> tags = new ArrayList<String>();
        while (in.hasNext()) {
            tags.add(in.nextString());
        }
        in.endArray();
        return tags;
    }

    List<SubscriptionPlan> readSubscriptionPlans(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<SubscriptionPlan> subscriptionPlans = new ArrayList<SubscriptionPlan>();
        while (in.hasNext()) {
            subscriptionPlans.add(SubscriptionPlan.valueOf(in.nextString()));
        }
        in.endArray();
        return subscriptionPlans;
    }
}

